definition module roundrobin


::	RR x
	=	{	done:: .[x]		// The elements that are done
		,	todo:: .[x]		// The active and the elements to do
		}

emptyRR		::					RR .x				// emptyRR                      = {[],[]}

toRR		:: [.x] [.x]	 -> RR .x				// toRR done todo               = {done,todo}
fromRR		::		!(RR .x) -> ([.x],[.x])			// fromRR {done,todo}           = (done,todo)

isEmptyRR	::		!(RR .x) -> (!Bool,!RR .x)		// isEmptyRR rr                 = rr==emptyRR
nodoneRR	::		!(RR .x) -> (!Bool,!RR .x)		// nodoneRR  rr                 = rr=={[],_}
notodoRR	::		!(RR .x) -> (!Bool,!RR .x)		// notodoRR  rr                 = rr=={_,[]}

resetRR		::		!(RR .x) -> RR .x				// resetRR        {done,todo}   = {[],(reverse done)++todo}
adddoneRR	:: .x	!(RR .x) -> RR .x				// adddoneRR    x {done,todo}   = {[x:done],todo}
inserttodoRR:: .x	!(RR .x) -> RR .x				// inserttodoRR x {done,todo}   = {done,[x:todo]}
appendtodoRR:: .x	!(RR .x) -> RR .x				// appendtodoRR x {done,todo}   = {done,todo++[x]}
getcurrentRR::		!(RR .x) -> (!.x,!RR .x)		// getcurrentRR {done,[x:todo]} = (x,{done,todo})
